#include "opensqlitefiledlg.h"

#include <QDebug>

OpenSqliteFileDlg::OpenSqliteFileDlg(QString path, QWidget *parent) :
    OpenFileDlg(path, parent)
{
}

bool OpenSqliteFileDlg::skip(QFileInfo fileInfo) {
    if ( fileInfo.isDir() ) return OpenFileDlg::skip(fileInfo);

    QString filename = fileInfo.absoluteFilePath();
    QFile file(filename);
    if (!file.open(QIODevice::ReadOnly)) {
        qDebug() << "Error openning file: " << filename;
        return true;
    }
    char header[16];
    if ( file.read(header, 16)!=16 ) {
        qDebug() << "Error reading header: " << filename;
        return true;
    }

    if ( QString(header)!="SQLite format 3" ) {
        qDebug() << "Not valid sqlite file: " << filename;
        return true;
    }

    return OpenFileDlg::skip(fileInfo);
}
