#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QSqlDatabase>
#include <QSqlError>

#include <QDebug>
#include <QFileDialog>

#include "application.h"
// #include "tabledlg.h"
// #include "querydlg.h"
#include "databasedlg.h"
#include "opensqlitefiledlg.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    qDebug() << "MainWindow::MainWindow";
    m_pDatabaseDlg = NULL;

    ui->setupUi(this);

    connect(ui->openBtt, SIGNAL(clicked()), SLOT(on_openDatabaseAction_triggered()));
    connect(ui->newBtt, SIGNAL(clicked()), SLOT(on_newDatabaseAction_triggered()));

    foreach (QString drv, QSqlDatabase::drivers()) {
        qDebug() << "Database Driver Found: " << drv;
    }

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowFlags(windowFlags() | Qt::Window);
#endif

    loadSettings();
}

MainWindow::~MainWindow()
{
    qDebug() << "MainWindow::~MainWindow";
    if ( m_db.isOpen() ) m_db.close();
    if ( m_pDatabaseDlg ) { delete m_pDatabaseDlg; m_pDatabaseDlg=NULL; }

    delete ui;
}

void MainWindow::loadSettings() {
    ui->listWidget->clear();

    Settings settings;
    QStringList list = settings.recentFiles();
    if (list.isEmpty()) {
        qDebug() << "list is empty";
        return;
    }

    for ( int c=list.length()-1; c>=0; c-- ) {
        if (QFile::exists(list[c])) {
            ui->listWidget->addItem(list[c]);
            continue;
        }

        qDebug() << "File not available anymore: " << list[c];
        list.removeAt(c);
    }
    settings.setRecentFiles(list);
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_newDatabaseAction_triggered() {
    QString filename = QFileDialog::getSaveFileName(this, "New Database file",
        QString(),
        "SQLite (*.sqlite)"
    );

    if ( filename.isEmpty() ) return;

    openDatabase(filename);
}

void MainWindow::on_openDatabaseAction_triggered() {
    QString filename;

#ifdef Q_WS_MAEMO_5
    OpenSqliteFileDlg dlg("/home/user", this);
    dlg.setWindowTitle("Database File");
    dlg.setAttribute(Qt::WA_Maemo5StackedWindow);
    dlg.setWindowFlags(Qt::Window);
    if ( dlg.exec() != QDialog::Accepted ) return;
    filename = dlg.filename();

#else
    filename = QFileDialog::getOpenFileName(this, "Database file",
        QString(),
        "SQLite (*.db *.sqlite);;All Files (*.*)"
    );
#endif

    if (filename.isEmpty()) return;
    openDatabase(filename);
}

bool MainWindow::openDatabase(QString filename) {
    if ( m_db.isOpen() ) {
        qDebug() << "closing previous database";
        m_db.close();
    }

    m_db = QSqlDatabase::addDatabase("QSQLITE"); // , dbuuid
    m_db.setDatabaseName(filename);
    /*
    db.setHostName(dbparam.hostname);
    db.setPort(dbparam.port);
    db.setUserName(dbparam.username);
    db.setPassword(dbparam.password);
    */

    if (!m_db.open()) {
        QSqlError e = m_db.lastError();
        qDebug() << e;
        return false;
    }

    Settings settings;
    QStringList recent = settings.recentFiles();
    recent.removeAll(filename);
    recent.append(filename);
    settings.setRecentFiles(recent);

    // reload list of databases
    loadSettings();

    // show database
    if ( m_pDatabaseDlg ) { delete m_pDatabaseDlg; m_pDatabaseDlg =NULL; }
    m_pDatabaseDlg = new DatabaseDlg(this);
#ifdef Q_WS_MAEMO_5
    m_pDatabaseDlg->setAttribute(Qt::WA_Maemo5StackedWindow);
    m_pDatabaseDlg->setWindowFlags(Qt::Window);
#endif
    m_pDatabaseDlg->show();

    return true;
}

void MainWindow::on_listWidget_doubleClicked(QModelIndex index) {
    /*
    QString text = ui->listWidget->item(index.row())->text();
    openDatabase(text);
    */
}

void MainWindow::on_listWidget_clicked(QModelIndex index){
    QString text = ui->listWidget->item(index.row())->text();
    openDatabase(text);
}
