#ifndef DATABASEDLG_H
#define DATABASEDLG_H

#include <QDialog>
#include <QModelIndex>

class TableDlg;
class QueryDlg;

namespace Ui {
    class DatabaseDlg;
}

class DatabaseDlg : public QDialog
{
    Q_OBJECT

public:
    explicit DatabaseDlg(QWidget *parent = 0);
    ~DatabaseDlg();

private:
    void loadTables();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::DatabaseDlg *ui;
    TableDlg        *m_pTableDlg;
    QueryDlg        *m_pQueryDlg;

private slots:
    void on_listWidget_clicked(QModelIndex index);
    void on_refreshBtt_clicked();
    void on_sqlBtt_clicked();
    void on_listWidget_doubleClicked(QModelIndex index);
};

#endif // DATABASEDLG_H
