#include "databasedlg.h"
#include "ui_databasedlg.h"

#include <QDebug>
#include <QDir>
#include <QMenuBar>
#include <QSqlDatabase>

#include "tabledlg.h"
#include "querydlg.h"

DatabaseDlg::DatabaseDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DatabaseDlg)
{
    m_pTableDlg = NULL;
    m_pQueryDlg = NULL;

    ui->setupUi(this);

    loadTables();
}

DatabaseDlg::~DatabaseDlg()
{
    delete ui;

    if ( m_pTableDlg ) { delete m_pTableDlg; m_pTableDlg=NULL; }
    if ( m_pQueryDlg ) { delete m_pQueryDlg; m_pQueryDlg=NULL; }
}

void DatabaseDlg::loadTables() {
    QSqlDatabase db = QSqlDatabase::database();

    // load tables
    ui->listWidget->clear();
    foreach ( QString table, db.tables(QSql::AllTables) ) {
        qDebug() << "Table: " << table;
        ui->listWidget->addItem(table);
    }

    QString filename = db.databaseName();
    setWindowTitle(filename.mid(filename.lastIndexOf('/')+1));
}

void DatabaseDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void DatabaseDlg::on_sqlBtt_clicked() {
    if ( m_pQueryDlg ) { delete m_pQueryDlg; m_pQueryDlg=NULL; }

    m_pQueryDlg = new QueryDlg(this);
#ifdef Q_WS_MAEMO_5
    m_pQueryDlg->setAttribute(Qt::WA_Maemo5StackedWindow);
    m_pQueryDlg->setWindowFlags(Qt::Window);
#endif
    m_pQueryDlg->show();
}

void DatabaseDlg::on_refreshBtt_clicked() {
    loadTables();
}

void DatabaseDlg::on_listWidget_clicked(QModelIndex index) {
    QString text = ui->listWidget->item(index.row())->text();

    if ( m_pTableDlg ) { delete m_pTableDlg; m_pTableDlg=NULL; }

    m_pTableDlg = new TableDlg(text, this);
#ifdef Q_WS_MAEMO_5
    m_pTableDlg->setAttribute(Qt::WA_Maemo5StackedWindow);
    m_pTableDlg->setWindowFlags(Qt::Window);
#endif
    m_pTableDlg->show();

}

void DatabaseDlg::on_listWidget_doubleClicked(QModelIndex index) {
}
