#include "application.h"

#include <QDebug>

// ---------------------------------------------------------------------------------------------------------
Settings::Settings() {
    qDebug() << "Settings::Settings";
}

Settings::~Settings() {
    qDebug() << "Settings::~Settings";
}

QStringList Settings::recentFiles() {
    qDebug() << "Settings::recentFiles";
    return value("recentFiles").toStringList();
}

void Settings::setRecentFiles(QStringList list) {
    qDebug() << "Settings::setRecentFiles: ";
    setValue("recentFiles", list);
}

// ---------------------------------------------------------------------------------------------------------

Application::Application(int argc, char *argv[]) :
    QApplication(argc, argv)
{
    qDebug() << "Application::Application";
    m_pMainWindow = NULL;

    // to be used by settings
    setOrganizationName("Crochik");
    setOrganizationDomain("www.crochik.com");
    setApplicationName("dbBrowser");
}

Application::~Application() {
    qDebug() << "Application::~Application";
    if ( m_pMainWindow ) { delete m_pMainWindow; m_pMainWindow=NULL; }
}

int Application::execute() {
    if ( !m_pMainWindow ) m_pMainWindow = new MainWindow();

#if defined(Q_WS_S60)
    m_pMainWindow->showMaximized();
#else
    m_pMainWindow->show();
#endif

    return QApplication::exec();
}

// ---------------------------------------------------------------------------------------------------------
