/*
 * Copyright (C) 2016 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import cuteTube 2.0
import QYouTube 1.0 as QYouTube
import ".."
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Tab {
    id: root

    property alias model: commentModel

    title: qsTr("Comments")
    showProgressIndicator: commentModel.status == QYouTube.ResourcesRequest.Loading
    tools: ToolBarLayout {

        BackToolIcon {}

        MyToolIcon {
            platformIconId: "toolbar-new-message"
            enabled: video.hasWriteScope
            onClicked: {
                dialogLoader.sourceComponent = commentDialog;
                dialogLoader.item.videoId = video.id;
                dialogLoader.item.open();
            }
        }

        MyToolIcon {
            platformIconId: "toolbar-refresh"
            enabled: commentModel.status != QYouTube.ResourcesRequest.Loading
            onClicked: commentModel.reload()
        }
    }

    ListView {
        id: view

        anchors {
            fill: parent
            topMargin: UI.PADDING_DOUBLE
        }
        cacheBuffer: 400
        highlightFollowsCurrentItem: false
        model: YouTubeCommentModel {
            id: commentModel

            onStatusChanged: if (status == QYouTube.ResourcesRequest.Failed) infoBanner.showMessage(errorString);
        }
        delegate: CommentDelegate {
            onThumbnailClicked: appWindow.pageStack.push(Qt.resolvedUrl("YouTubeUserPage.qml")).load(userId)
        }
    }

    ScrollDecorator {
        flickableItem: view
    }

    Label {
        anchors {
            fill: parent
            margins: UI.PADDING_DOUBLE
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        font.pixelSize: 60
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        text: qsTr("No comments found")
        visible: (commentModel.status >= QYouTube.ResourcesRequest.Ready) && (commentModel.count == 0)
    }

    Loader {
        id: dialogLoader
    }

    Component {
        id: commentDialog

        YouTubeCommentDialog {}
    }
}
