#include "vimeomychannelwindow.h"
#include "../base/session.h"
#include "vimeoprofiletab.h"
#include "vimeovideolisttab.h"
#include "vimeouseralbumlisttab.h"
#include "vimeousergrouplisttab.h"
#include "vimeosubscriptionstab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

VimeoMyChannelWindow::VimeoMyChannelWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_likesAction(new QAction("Like", this)),
    m_albumsAction(new QAction("Alb", this)),
    m_groupsAction(new QAction("Gro", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new VimeoProfileTab(m_session, "me", m_tabWidget)),
    m_uploadsTab(0),
    m_likesTab(0),
    m_albumsTab(0),
    m_groupsTab(0),
    m_subscriptionsTab(0)
{
    this->setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_likesAction->setCheckable(true);
    m_likesAction->setActionGroup(m_actionGroup);

    m_albumsAction->setCheckable(true);
    m_albumsAction->setActionGroup(m_actionGroup);

    m_groupsAction->setCheckable(true);
    m_groupsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_likesAction);
    m_menu->addAction(m_albumsAction);
    m_menu->addAction(m_groupsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    this->connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    this->connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    this->connect(m_likesAction, SIGNAL(triggered()), this, SLOT(showLikes()));
    this->connect(m_albumsAction, SIGNAL(triggered()), this, SLOT(showAlbums()));
    this->connect(m_groupsAction, SIGNAL(triggered()), this, SLOT(showGroups()));
    this->connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    this->showProfile();
    this->onOrientationChanged();
}

void VimeoMyChannelWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void VimeoMyChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    this->setWindowTitle(tr("Profile"));
    this->clearMenuActions();
}

void VimeoMyChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new VimeoVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(VIMEO_UPLOADS_FEED);
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    this->setWindowTitle(tr("Uploads"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_uploadsTab->actions());
}

void VimeoMyChannelWindow::showLikes() {
    if (!m_likesTab) {
        m_likesTab = new VimeoVideoListTab(m_session, this);
        m_likesTab->setVideoFeed(VIMEO_LIKES_FEED);
        m_tabWidget->addWidget(m_likesTab);
    }

    m_tabWidget->setCurrentWidget(m_likesTab);
    this->setWindowTitle(tr("Likes"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_likesTab->actions());
}

void VimeoMyChannelWindow::showAlbums() {
    if (!m_albumsTab) {
        m_albumsTab = new VimeoUserAlbumListTab(m_session, this);
        m_tabWidget->addWidget(m_albumsTab);
    }

    m_tabWidget->setCurrentWidget(m_albumsTab);
    this->setWindowTitle(tr("Albums"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_albumsTab->actions());
}

void VimeoMyChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new VimeoUserGroupListTab(m_session, this);
        m_tabWidget->addWidget(m_groupsTab);
    }

    m_tabWidget->setCurrentWidget(m_groupsTab);
    this->setWindowTitle(tr("Groups"));
    this->clearMenuActions();
}

void VimeoMyChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new VimeoSubscriptionsTab(m_session, this);
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    this->setWindowTitle(tr("Subscriptions"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_subscriptionsTab->actions());
}
