#ifndef VIMEOCATEGORIESDIALOG_H
#define VIMEOCATEGORIESDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class VimeoCategoryModel;
class ListView;
class QModelIndex;

class VimeoCategoriesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit VimeoCategoriesDialog(QWidget *parent = 0);

private slots:
    void onCategoryChosen(const QModelIndex &index);

signals:
    void categoryChosen(Services::VideoService, const QString &title, const QString &feed);

private:
    VimeoCategoryModel *m_model;
    ListView *m_view;
};

#endif // VIMEOCATEGORIESDIALOG_H
