#ifndef DAILYMOTIONVIDEOINFOWINDOW_H
#define DAILYMOTIONVIDEOINFOWINDOW_H

#include "stackedwindow.h"
#include "../base/videoitem.h"

class Session;
class DailymotionVideoDescriptionTab;
class DailymotionVideoCommentsTab;
class DailymotionRelatedVideosTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class DailymotionVideoInfoWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showInfo();
    void showComments();
    void showRelatedVideos();

private:
    QSharedPointer<VideoItem> m_video;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_infoAction;
    QAction *m_commentsAction;
    QAction *m_relatedAction;
    QStackedWidget *m_tabWidget;
    DailymotionVideoDescriptionTab *m_infoTab;
    DailymotionVideoCommentsTab *m_commentsTab;
    DailymotionRelatedVideosTab *m_relatedTab;
};

#endif // DAILYMOTIONVIDEOINFOWINDOW_H
