#include "dailymotionchannelwindow.h"
#include "dailymotionprofiletab.h"
#include "dailymotionvideolisttab.h"
#include "dailymotionplaylistlisttab.h"
#include "dailymotiongrouplisttab.h"
#include "dailymotionuserlisttab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

DailymotionChannelWindow::DailymotionChannelWindow(Session *session, const QString &userId, QWidget *parent) :
    StackedWindow(session, parent),
    m_userId(userId),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_favouritesAction(new QAction("Fav", this)),
    m_playlistsAction(new QAction("Play", this)),
    m_groupsAction(new QAction("Gro", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new DailymotionProfileTab(m_session, m_userId, m_tabWidget)),
    m_uploadsTab(0),
    m_favouritesTab(0),
    m_playlistsTab(0),
    m_groupsTab(0),
    m_subscriptionsTab(0)
{
    this->setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_favouritesAction->setCheckable(true);
    m_favouritesAction->setActionGroup(m_actionGroup);

    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_groupsAction->setCheckable(true);
    m_groupsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_favouritesAction);
    m_menu->addAction(m_playlistsAction);
    m_menu->addAction(m_groupsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    this->connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    this->connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    this->connect(m_favouritesAction, SIGNAL(triggered()), this, SLOT(showFavourites()));
    this->connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));
    this->connect(m_groupsAction, SIGNAL(triggered()), this, SLOT(showGroups()));
    this->connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    this->showProfile();
    this->onOrientationChanged();
}

void DailymotionChannelWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void DailymotionChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    this->setWindowTitle(tr("Profile"));
    this->clearMenuActions();
}

void DailymotionChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new DailymotionVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(QString("https://api.dailymotion.com/user/%1/videos?limit=30").arg(m_userId));
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    this->setWindowTitle(tr("Uploads"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_uploadsTab->actions());
}

void DailymotionChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new DailymotionVideoListTab(m_session, this);
        m_favouritesTab->setVideoFeed(QString("https://api.dailymotion.com/user/%1/favorites?limit=30").arg(m_userId));
        m_tabWidget->addWidget(m_favouritesTab);
    }

    m_tabWidget->setCurrentWidget(m_favouritesTab);
    this->setWindowTitle(tr("Favourites"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_favouritesTab->actions());
}

void DailymotionChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new DailymotionPlaylistListTab(m_session, this);
        m_playlistsTab->setPlaylistFeed(QString("https://api.dailymotion.com/user/%1/playlists?limit=30").arg(m_userId));
        m_tabWidget->addWidget(m_playlistsTab);
    }

    m_tabWidget->setCurrentWidget(m_playlistsTab);
    this->setWindowTitle(tr("Playlists"));
    this->clearMenuActions();
}

void DailymotionChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new DailymotionGroupListTab(m_session, this);
        m_groupsTab->setGroupFeed(QString("https://api.dailymotion.com/user/%1/groups?limit=30").arg(m_userId));
        m_tabWidget->addWidget(m_groupsTab);
    }

    m_tabWidget->setCurrentWidget(m_groupsTab);
    this->setWindowTitle(tr("Groups"));
    this->clearMenuActions();
}

void DailymotionChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new DailymotionUserListTab(m_session, m_userId, this);
        m_subscriptionsTab->setFeed(QString("https://api.dailymotion.com/user/%1/following?limit=30").arg(m_userId));
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    this->setWindowTitle(tr("Subscriptions"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_subscriptionsTab->actions());
}
