#ifndef ACCOUNTSDIALOG_H
#define ACCOUNTSDIALOG_H

#include "abstractdialog.h"

class DailymotionAccountsListModel;
class YouTubeAccountsListModel;
class VimeoAccountsListModel;
class VideoServiceSelector;
class ListView;
class Session;
class QLabel;
class QPushButton;
class QLineEdit;
class QGridLayout;
class QScrollArea;
class QMenu;
class QAction;
class QModelIndex;

class AccountsDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit AccountsDialog(Session *session, QWidget *parent = 0);
    
private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }
    void showFacebookAuthDialog();
    void showTwitterAuthDialog();

private slots:
    void onNameTextChanged(const QString &text);
    void showAuthDialog();
    void showYouTubeAuthDialog();
    void showDailymotionAuthDialog();
    void showVimeoAuthDialog();
    void onFacebookButtonClicked();
    void onTwitterButtonClicked();
    void switchYouTubeAccount(const QModelIndex &index);
    void switchDailymotionAccount(const QModelIndex &index);
    void switchVimeoAccount(const QModelIndex &index);
    void showYouTubeContextMenu(const QPoint &pos);
    void showDailymotionContextMenu(const QPoint &pos);
    void showVimeoContextMenu(const QPoint &pos);
    void deleteYouTubeAccount();
    void deleteDailymotionAccount();
    void deleteVimeoAccount();
    void onSignedInOrOutOfFacebook();
    void onSignedInOrOutOfTwitter();

private:
    Session *m_session;
    QLineEdit *m_nameEdit;
    VideoServiceSelector *m_serviceSelector;
    QPushButton *m_loginButton;
    DailymotionAccountsListModel *m_dailymotionModel;
    YouTubeAccountsListModel *m_youtubeModel;
    VimeoAccountsListModel *m_vimeoModel;
    ListView *m_dailymotionView;
    ListView *m_youtubeView;
    ListView *m_vimeoView;
    QLabel *m_facebookLabel;
    QLabel *m_twitterLabel;
    QPushButton *m_facebookButton;
    QPushButton *m_twitterButton;
    QScrollArea *m_scrollArea;
    QMenu *m_contextMenu;
    QAction *m_dailymotionDeleteAction;
    QAction *m_youtubeDeleteAction;
    QAction *m_vimeoDeleteAction;
    QGridLayout *m_grid;
};

#endif // ACCOUNTSDIALOG_H
