#ifndef URLGRABBER_H
#define URLGRABBER_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QList>
#include <QSet>
#include <QVariant>

class QNetworkAccessManager;
class QNetworkReply;

class UrlGrabber : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool busy
               READ busy
               NOTIFY busyChanged)

public:
    enum Mode {
        PlaybackMode = 0,
        DownloadMode
    };

public:
    explicit UrlGrabber(UrlGrabber::Mode mode = UrlGrabber::PlaybackMode, QObject *parent = 0);
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QSet<int> youtubeQualitySet() const { return m_youtubeSet; }
    inline QSet<QByteArray> dailymotionQualitySet() const { return m_dailymotionSet; }
    inline QSet<QByteArray> vimeoQualitySet() const { return m_vimeoSet; }
    inline bool busy() const { return m_busy; }

public slots:
    void getVideoUrl(int service, const QString &id);
    void getYouTubeVideoUrl(const QString &id);
    void getDailymotionVideoUrl(const QString &id);
    void getVimeoVideoUrl(const QString &id);
    void getAvailableVideoFormats(int service, const QString &id);
    void getAvailableYouTubeVideoFormats(const QString &id);
    void getAvailableDailymotionVideoFormats(const QString &id);
    void getAvailableVimeoVideoFormats(const QString &id);
    void getDailymotionUrl(const QUrl &url);
    void getVimeoRedirect(const QUrl &url);
    inline void setYouTubeQualitySet(const QSet<int> &qualitySet) { m_youtubeSet = qualitySet; }
    inline void setDailymotionQualitySet(const QSet<QByteArray> &qualitySet) { m_dailymotionSet = qualitySet; }
    inline void setVimeoQualitySet(const QSet<QByteArray> &qualitySet) { m_vimeoSet = qualitySet; }

private slots:
    void parseYouTubeVideoPage();
    void parseDailymotionVideoPage();
    void checkDailymotionUrl();
    void parseVimeoVideoPage();
    void checkVimeoRedirect();
    void checkYouTubeVideoFormats();
    void checkDailymotionFormats();
    void checkDailymotionVideoFormats();
    void checkDailymotionVideoQualityFormats();
    void checkVimeoVideoFormats();

private:
    void getDailymotionFormats(const QUrl &url);
    void getDailymotionVideoQualityFormats(const QUrl &url);
    void setBusy(bool isBusy, const QString &message = QString(), int numberOfOperations = 1);

signals:
    void gotVideoUrl(const QUrl &url);
    void gotVideoFormats(const QVariantList &formats);
    void busyChanged(bool isBusy);
    void busy(const QString &message, int numberOfOperations = 1);
    void busyProgressChanged(int progress);
    void error(const QString &errorString);

private:
    UrlGrabber::Mode m_mode;
    QNetworkAccessManager *m_nam;
    QNetworkAccessManager *m_dailymotionPlaybackNam;
    QSet<int> m_youtubeSet;
    QSet<QByteArray> m_dailymotionSet;
    QSet<QByteArray> m_vimeoSet;
    QList<int> m_youtubeList;
    QList<QByteArray> m_dailymotionList;
    QMap<int, QString> m_youtubeMap;
    QMap<QString, QString> m_dailymotionMap;
    QMap<QString, QString> m_vimeoMap;
    bool m_busy;
};

#endif // URLGRABBER_H
