#include "thumbnaildownloader.h"
#include <QNetworkAccessManager>
#include <QImage>

ThumbnailDownloader::ThumbnailDownloader(QObject *parent) :
    QObject(parent),
    m_nam(0)
{
}

void ThumbnailDownloader::downloadThumbnail(const QUrl &url) {
    if (!this->networkAccessManager()) {
        this->setNetworkAccessManager(new QNetworkAccessManager(this));
    }

    QNetworkRequest request(url);
    QNetworkReply *reply = this->networkAccessManager()->get(request);
    this->connect(reply, SIGNAL(finished()), this, SLOT(onThumbnailDownloaded()));
}

void ThumbnailDownloader::onThumbnailDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        return;
    }

    emit gotThumbnail(reply);
}
