#ifndef SEARCHLISTMODEL_H
#define SEARCHLISTMODEL_H

#include <QSortFilterProxyModel>

class QStringListModel;
class QStringList;
class QSettings;

class SearchListModel : public QSortFilterProxyModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)

public:
    explicit SearchListModel(QObject *parent = 0);
    ~SearchListModel();
    Q_INVOKABLE QString regexMatch(QString str) const;
    inline QString query() const { return m_query; }
    void saveSearches();
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role = "display") const;
    inline QString highlightColor() const { return m_highlight; }
    inline void setHighlightColor(const QString &color) { m_highlight = color; }

public slots:
    void addSearch(const QString &query);
    void removeSearch(int row);
    void setQuery(const QString &query);
    void clearSearches();

private:
    void setSearches(const QStringList &searches);

signals:
    void alert(const QString &message);
    void countChanged(int count);
    void queryChanged(const QString &query);

private:
    QString m_query;
    QString m_highlight;
    QStringListModel *m_model;
    QSettings *m_settings;
};

#endif // SEARCHLISTMODEL_H
