#include "youtubeuserplaylistlisttab.h"
#include "youtubeplaylistdelegate.h"
#include "youtubenewplaylistdialog.h"
#include "youtubeplaylistvideoswindow.h"

YouTubeUserPlaylistListTab::YouTubeUserPlaylistListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new YouTubeUserPlaylistListModel(m_session, this)),
    m_contextMenu(new QMenu(this)),
    m_deleteAction(m_contextMenu->addAction(tr("Delete"), this, SLOT(deletePlaylist()))),
    m_newPlaylistAction(new QAction(tr("New playlist"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    addAction(m_newPlaylistAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();   

    if (m_session->youtube()->playlistsLoaded()) {
        onPlaylistsLoaded();
    }
    else {
        m_session->toggleBusy(true);
        connect(m_session->youtube(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    connect(m_newPlaylistAction, SIGNAL(triggered()), this, SLOT(showNewPlaylistDialog()));

    onOrientationChanged();
}

void YouTubeUserPlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeUserPlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeUserPlaylistListTab::onPlaylistsLoaded() {
    m_session->toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void YouTubeUserPlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showPlaylist(m_model->get(index.row()));
    }
}

void YouTubeUserPlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(m_session, playlist, m_session->currentWindow());
    window->show();
}

void YouTubeUserPlaylistListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_deleteAction);
}

void YouTubeUserPlaylistListTab::deletePlaylist() {
    m_session->youtube()->deletePlaylist(m_listView->currentIndex().data(YouTubeUserPlaylistListModel::PlaylistIdRole).toString());
}

void YouTubeUserPlaylistListTab::showNewPlaylistDialog() {
    YouTubeNewPlaylistDialog *dialog = new YouTubeNewPlaylistDialog(this);
    dialog->open();

    connect(dialog, SIGNAL(playlistCreated(NewPlaylist)), m_session->youtube(), SLOT(createPlaylist(NewPlaylist)));
}
