#ifndef YOUTUBEUSERLISTTAB_H
#define YOUTUBEUSERLISTTAB_H

#include "abstracttab.h"
#include "youtubeuserlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>

class YouTubeUserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubeUserListTab(Session *session, const QString &userId, QWidget *parent = 0);
    void setFeed(const QString &feed);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    Session *m_session;
    QString m_userId;
    YouTubeUserListModel *m_model;
    ListView *m_listView;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEUSERLISTTAB_H
