#ifndef URLGRABBER_H
#define URLGRABBER_H

#include "enums.h"
#include <QObject>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QUrl>
#include <QList>
#include <QSet>

class UrlGrabber : public QObject
{
    Q_OBJECT

public:
    enum Mode {
        PlaybackMode = 0,
        DownloadMode
    };

public:
    explicit UrlGrabber(UrlGrabber::Mode mode = UrlGrabber::PlaybackMode, QObject *parent = 0);
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }

public slots:
    void getVideoUrl(Services::VideoService service, const QString &id);
    void getYouTubeVideoUrl(const QString &id);
    void getDailymotionVideoUrl(const QString &id);
    void getVimeoVideoUrl(const QString &id);
    void getXHamsterVideoUrl(const QString &url);
    void getXVideosVideoUrl(const QString &url);
    void getJoggsVideoUrl(const QString &url);
    void getYouJizzVideoUrl(const QString &url);
    void getRampantTVVideoUrl(const QString &url);
    inline void setYouTubeQualitySet(const QSet<int> &qualitySet) { m_youtubeSet = qualitySet; }
    inline void setDailymotionQualitySet(const QSet<QByteArray> &qualitySet) { m_dailymotionSet = qualitySet; }
    inline void setVimeoQualitySet(const QSet<QByteArray> &qualitySet) { m_vimeoSet = qualitySet; }

private slots:
    void parseYouTubeVideoPage();
    void parseDailymotionVideoPage();
    void checkDailymotionRedirect();
    void parseVimeoVideoPage();
    void checkVimeoRedirect();
    void parseXHamsterVideoPage();
    void parseXVideosVideoPage();
    void parseJoggsVideoPage();
    void parseYouJizzVideoPage();
    void parseRampantTVVideoPage();
    void parseRampantTVVideoParams();
    void updateProgress(qint64 bytesReceived, qint64 bytesTotal);

private:
    void getDailymotionRedirect(const QUrl &url);
    void getVimeoRedirect(const QUrl &url);
    void getRampantTVVideoParams(const QUrl &url);

signals:
    void gotVideoUrl(const QString &url);
    void busy(const QString &message, int numberOfOperations = 100);
    void busyProgressChanged(int progress);
    void error(const QString &errorString);

private:
    UrlGrabber::Mode m_mode;
    QNetworkAccessManager *m_nam;
    QNetworkAccessManager *m_dailymotionPlaybackNam;
    QSet<int> m_youtubeSet;
    QSet<QByteArray> m_dailymotionSet;
    QSet<QByteArray> m_vimeoSet;
    QList<int> m_youtubeList;
    QList<QByteArray> m_dailymotionList;
};

#endif // URLGRABBER_H
