#ifndef TWITTERAUTHDIALOG_H
#define TWITTERAUTHDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

class TwitterAuthDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit TwitterAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { setFixedHeight(340); }
    inline void setPortraitLayout() { setFixedHeight(600); }

private slots:
    void setAuthUrl(const QUrl &url);
    void checkUrlForToken(const QUrl &url);
        
private:
    Session *m_session;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // TWITTERAUTHDIALOG_H
