#include "thumbnaildownloader.h"

ThumbnailDownloader::ThumbnailDownloader(QObject *parent) :
    QObject(parent),
    m_nam(0)
{
}

void ThumbnailDownloader::downloadThumbnail(const QUrl &url) {
    if (!networkAccessManager()) {
        setNetworkAccessManager(new QNetworkAccessManager(this));
    }

    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(onThumbnailDownloaded()));
}

void ThumbnailDownloader::onThumbnailDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        return;
    }

    emit gotThumbnail(reply);
}
