#ifndef SEARCHLISTMODEL_H
#define SEARCHLISTMODEL_H

#include <QSortFilterProxyModel>
#include <QStringListModel>
#include <QStringList>
#include <QSettings>

class SearchListModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    explicit SearchListModel(QObject *parent = 0);
    ~SearchListModel();
    QString regexMatch(QString str) const;
    inline QString query() const { return m_query; }
    void addSearch(const QString &query);
    void removeSearch(int row);
    void saveSearches();
    QVariant data(const QModelIndex &index, int role) const;

public slots:
    void setQuery(const QString &query);
    void clearSearches();

private:
    void setSearches(const QStringList &searches);

signals:
    void alert(const QString &message);

private:
    QString m_query;
    QStringListModel *m_model;
    QSettings *m_settings;
};

#endif // SEARCHLISTMODEL_H
