#ifndef PLAYBACKLISTMODEL_H
#define PLAYBACKLISTMODEL_H

#include "abstractvideolistmodel.h"
#include "thumbnailcache.h"

class PlaybackListModel : public AbstractVideoListModel
{
    Q_OBJECT

public:
    explicit PlaybackListModel(ThumbnailCache *cache, QObject *parent = 0);
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    void addVideo(QSharedPointer<VideoItem> video);
    void addVideos(QList< QSharedPointer<VideoItem> > videos);

public slots:
    void removeVideo(int row);
    void removeVideos();

signals:
    void alert(const QString &message);
    void countChanged();
};

#endif // PLAYBACKLISTMODEL_H
