#ifndef DAILYMOTIONMETADATADIALOG_H
#define DAILYMOTIONMETADATADIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "dailymotionuploadcategoryselector.h"
#include "videometadata.h"
#include <QLineEdit>
#include <QTextEdit>
#include <QPushButton>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>

class DailymotionMetadataDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionMetadataDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void setMetadata(const VideoMetadata &metadata);
    void submitMetadata();

private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QLineEdit *m_tagsEdit;
    DailymotionUploadCategorySelector *m_categorySelector;
    QCheckBox *m_commentsCheckbox;
    QCheckBox *m_privateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONMETADATADIALOG_H
