#include "dailymotioncommentdialog.h"
#include <QLabel>

DailymotionCommentDialog::DailymotionCommentDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_video(video),
    m_commentEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Add comment"));

    QLabel *label = new QLabel(tr("Your comment"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(label);
    vbox->addWidget(m_commentEdit);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_doneButton->setEnabled(false);

    connect(m_commentEdit, SIGNAL(textChanged()), this, SLOT(onCommentTextChanged()));
    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(submitComment()));

    onOrientationChanged();
}

void DailymotionCommentDialog::setLandscapeLayout() {
    setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void DailymotionCommentDialog::setPortraitLayout() {
    setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void DailymotionCommentDialog::onCommentTextChanged() {
    m_doneButton->setEnabled(!m_commentEdit->toPlainText().isEmpty());
}

void DailymotionCommentDialog::submitComment() {
    NewComment comment;
    comment.setVideoId(m_video.data()->videoId());
    comment.setBody(m_commentEdit->toPlainText());

    m_session->dailymotion()->addComment(comment);

    accept();
}
