#ifndef YOUTUBERELATEDVIDEOSTAB_H
#define YOUTUBERELATEDVIDEOSTAB_H

#include "abstracttab.h"
#include "session.h"
#include "youtubevideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QGridLayout>

class YouTubeRelatedVideosTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeRelatedVideosTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showVideoInfo(QSharedPointer<VideoItem> video);

private slots:
    void setMenuActions();
    void onLoadingChanged();
    void addVideosToFavourites();
    void addVideosToPlaylist();
    void addVideosToWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    
private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    YouTubeVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_addToFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBERELATEDVIDEOSTAB_H
