#ifndef YOUTUBENEWPLAYLISTDIALOG_H
#define YOUTUBENEWPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include "newplaylist.h"
#include <QScrollArea>
#include <QLineEdit>
#include <QTextEdit>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

class YouTubeNewPlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeNewPlaylistDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void createPlaylist();
    
signals:
    void playlistCreated(const NewPlaylist &playlist);

private:
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QCheckBox *m_privateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBENEWPLAYLISTDIALOG_H
