#ifndef XTUBEVIDEOLISTWINDOW_H
#define XTUBEVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "xtubevideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class XTubeVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit XTubeVideoListWindow(Session *session, QWidget *parent);
    void search(const QString &query,
                Services::VideoService service,
                Queries::QueryOrder order,
                Queries::TimeFilter time,
                Queries::DurationFilter duration);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void addVideoDownloads();
    void addAudioDownloads();
    void onItemClicked(const QModelIndex &index);

private:
    ListView *m_listView;
    XTubeVideoListModel *m_model;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QLabel *m_noResultsLabel;
};

#endif // XTUBEVIDEOLISTWINDOW_H
