#ifndef VIDEOMETADATA_H
#define VIDEOMETADATA_H

#include <QString>

class VideoMetadata
{

public:
    inline explicit VideoMetadata() {}
    inline bool isEmpty() const { return m_title.isEmpty(); }
    inline QString filePath() const { return m_filePath; }
    inline void setFilePath(const QString &filePath) { m_filePath = filePath; }
    inline QString uploadAttribute() const { return m_attribute; }
    inline void setUploadAttribute(const QString &attribute) { m_attribute = attribute; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline QString tags() const { return m_tags; }
    inline void setTags(const QString &tags) { m_tags = tags; }
    inline QString category() const { return m_category; }
    inline void setCategory(const QString &category) { m_category = category; }
    inline QString responsesPermission() const { return m_responsesPermission; }
    inline void setResponsesPermission(const QString &permission) { m_responsesPermission = permission; }
    inline QString commentsPermission() const { return m_commentsPermission; }
    inline void setCommentsPermission(const QString &permission) { m_commentsPermission = permission; }
    inline QString commentVotingPermission() const { return m_commentVotingPermission; }
    inline void setCommentVotingPermission(const QString &permission) { m_commentVotingPermission = permission; }
    inline QString ratingsPermission() const { return m_ratingsPermission; }
    inline void setRatingsPermission(const QString &permission) { m_ratingsPermission = permission; }
    inline QString listingsPermission() const { return m_listingsPermission; }
    inline void setListingsPermission(const QString &permission) { m_listingsPermission = permission; }
    inline QString syndicationPermission() const { return m_syndicationPermission; }
    inline void setSyndicationPermission(const QString &permission) { m_syndicationPermission = permission; }
    inline QString embedPermission() const { return m_embedPermission; }
    inline void setEmbedPermission(const QString &permission) { m_embedPermission = permission; }
    inline QString autoPlayPermission() const { return m_autoPlayPermission; }
    inline void setAutoPlayPermission(const QString &permission) { m_autoPlayPermission = permission; }
    inline QString privateString() const { return isPrivate() ? "true" : "false"; }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; }

private:
    QString m_filePath;
    QString m_attribute;
    QString m_title;
    QString m_description;
    QString m_tags;
    QString m_category;
    QString m_responsesPermission;
    QString m_commentsPermission;
    QString m_commentVotingPermission;
    QString m_ratingsPermission;
    QString m_listingsPermission;
    QString m_syndicationPermission;
    QString m_embedPermission;
    QString m_autoPlayPermission;
    bool m_private;
};

#endif // VIDEOMETADATA_H
