#ifndef DAILYMOTIONGROUPLISTWINDOW_H
#define DAILYMOTIONGROUPLISTWINDOW_H

#include "stackedwindow.h"
#include "dailymotiongrouplistmodel.h"
#include "listview.h"
#include <QLabel>

class DailymotionGroupListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionGroupListWindow(Session *session, QWidget *parent);
    void setGroupFeed(const QString &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    DailymotionGroupListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONGROUPLISTWINDOW_H
