#include "vimeouserlistmodel.h"
#include "feedurls.h"
#include "vimeo.h"
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QTimer>

VimeoUserListModel::VimeoUserListModel(QObject *parent) :
    AbstractUserListModel(parent),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoUserListModel::clear() {
    AbstractUserListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoUserListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreUsers();
    }
}

void VimeoUserListModel::setFeed(const QUrl &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoUserListModel::getUsers(QUrl feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = Vimeo::instance()->createReply(this->feed(), this->offset());
    reply->setParent(this);
    this->connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
}

void VimeoUserListModel::addUsers() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("contact");

        for (int i = 0; i < entries.size(); i++) {
            UserItem *user = new UserItem;
            user->loadVimeoContact(entries.at(i).toElement());
            QMetaObject::invokeMethod(this, "appendUser", Qt::QueuedConnection, Q_ARG(QSharedPointer<UserItem>, QSharedPointer<UserItem>(user)));
        }

        QDomElement statNode = responseNode.firstChildElement("contacts");

        QTimer::singleShot(1000, this, SLOT(stopLoading()));
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoUserListModel::getMoreUsers() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getUsers();
    }
}
