#ifndef VIMEORELATEDVIDEOSTAB_H
#define VIMEORELATEDVIDEOSTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class VimeoVideoListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;
class QMenu;

class VimeoRelatedVideosTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoRelatedVideosTab(QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showVideoInfo(QSharedPointer<VideoItem> video);

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void addVideosToLikes();
    void addVideosToAlbum();
    void addVideosToWatchLaterAlbum();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void addVideoToLikes();
    void showAlbumDialog();
    void addVideoToAlbum(const QString &id);
    void addVideoToNewAlbum(const QVariantMap &album);
    void addVideoToWatchLaterAlbum();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);

private:
    QSharedPointer<VideoItem> m_video;
    VimeoVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_addToLikesAction;
    QAction *m_addToAlbumAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_addToLikesContextAction;
    QAction *m_addToAlbumContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEORELATEDVIDEOSTAB_H
