#ifndef VIDEOPLAYBACKWINDOW_H
#define VIDEOPLAYBACKWINDOW_H

#include "stackedwindow.h"
#include "videowidget.h"
#include "videocontrols.h"

class VideoPlaybackWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VideoPlaybackWindow(QList< QSharedPointer<VideoItem> > playlist, QWidget *parent = 0);
    ~VideoPlaybackWindow();

protected:
    bool event(QEvent *event);
    void keyPressEvent(QKeyEvent *event);

private slots:
    void toggleControls();
    void onStateChanged(QMediaPlayer::State state);
    
private:
    ScreenOrientation::Orientation m_oldOrientation;
    VideoWidget *m_videoWidget;
    QMediaPlayer *m_player;
    VideoControls *m_controls;
};

#endif // VIDEOPLAYBACKWINDOW_H
