#ifndef VIMEOUSERGROUPLISTMODEL_H
#define VIMEOUSERGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class VimeoUserGroupListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
#endif
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit VimeoUserGroupListModel(QObject *parent = 0);
    ~VimeoUserGroupListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE GroupItem* getFromQML(int row) const;
#endif

private slots:
    void onGroupAdded(int row);
    void onGroupRemoved(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // VIMEOUSERGROUPLISTMODEL_H
