# -*- coding: utf-8 -*-

"""
This module holds the application settings.
"""

from PyQt4.QtCore import QString, QStringList

class GeneralSettings():
    """
    Provides general settings.
    """
    autoOrientation = True

class YouTubeAPISettings():
    """
    Provides the settings for access to the YouTube API.
    """
    userDict = {}
    defaultUser = ""
    raiseNoAccountFoundDialog = True
    categoryFilter = "All"
    locationFilter = "All"

class VideoPlaybackSettings():
    """
    Provides the video playback settings.
    """
    playbackFormat = 18
    formatList = [17, 18]
    
class VideoDownloadSettings():
    """
    Provides the video download settings.
    """
    downloadFolder = "/home/user/MyDocs"
    downloadFormat = 18
    formatList = [17, 18, 34, 35, 22]
    defaultTaskStatus = "paused"
    
class SearchSettings():
    """
    Provides the settings for YouTube searches.
    """
    searchOrder = 0
    recentSearches = QStringList()
    
class VideoSharingSettings():
    """
    Provides the setting for sharing videos via social media.
    """
    raiseTwitterAuthorisationDialog = True
    twitterAccessTokenKey = ""
    twitterAccessTokenSecret = ""
    
    raiseFacebookAuthorisationDialog = True
    facebookAccessToken = ""
