# -*- coding: utf-8 -*-

"""
Module implementing AddCommentDialog.
"""

from PyQt4.QtGui import QDialog
from PyQt4.QtCore import *
try:
    from PyQt4.QtMaemo5 import QMaemo5InformationBox
except:
    pass
import youtubeservice

from Ui_addcommentdialog import Ui_AddCommentDialog

class AddCommentDialog(QDialog, Ui_AddCommentDialog):
    """
    Class documentation goes here.
    """
    def __init__(self, parent, videoID):
        """
        Constructor
        """
        QDialog.__init__(self, parent)
        self.setupUi(self)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
            pass
        self.videoID = videoID
        self.show()
    
    @pyqtSignature("")
    def on_submitButton_clicked(self):
        """
        Uses the YouTube API to add a comment
        to the video referenced by videoID.
        """
        try:
            youtubeservice.YouTubeDataService.addComment(self.commentEdit.toPlainText(), self.videoID)
            QMaemo5InformationBox.information(self, "Comment added")
        except:
            QMaemo5InformationBox.information(self, "Unable to add comment")
