/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */


#if QT_VERSION >= 0x050000
#include <QUrlQuery>
#endif
#include "tunein.h"
#include "tuneingenrelist.h"
#include "tuneinlanguagelist.h"
#include "tuneinnamelist.h"
#include "tuneinstationlist.h"
#include "tuneinstation.h"
#include "tuneinpodcastlist.h"
#include "tuneinpodcastepisodelist.h"
#include "tuneinurls.h"
#include "../base/networkaccessmanager.h"

TuneIn::TuneIn(QObject *parent) :
    QObject(parent)
{
}

TuneIn::~TuneIn() {}

QList< QPair<QString, QString> > TuneIn::getCountries() {
    return QList< QPair<QString, QString> >()
            << QPair<QString, QString>(tr("Afghanistan"), "r100287")
            << QPair<QString, QString>(tr("Albania"), "r100288")
            << QPair<QString, QString>(tr("Algeria"), "r100289")
            << QPair<QString, QString>(tr("American Samoa"), "r101565")
            << QPair<QString, QString>(tr("Andorra"), "r100290")
            << QPair<QString, QString>(tr("Angola"), "r101220")
            << QPair<QString, QString>(tr("Antarctica"), "r100292")
            << QPair<QString, QString>(tr("Argentina"), "r100294")
            << QPair<QString, QString>(tr("Armenia"), "r100295")
            << QPair<QString, QString>(tr("Australia"), "r101356")
            << QPair<QString, QString>(tr("Austria"), "r101221")
            << QPair<QString, QString>(tr("Azerbaijan"), "r101222")
            << QPair<QString, QString>(tr("Bahrain"), "r100300")
            << QPair<QString, QString>(tr("Bangladesh"), "r100301")
            << QPair<QString, QString>(tr("Belarus"), "r100303")
            << QPair<QString, QString>(tr("Belgium"), "r100304")
            << QPair<QString, QString>(tr("Belize"), "r100305")
            << QPair<QString, QString>(tr("Benin"), "r100997")
            << QPair<QString, QString>(tr("Bermuda"), "r100306")
            << QPair<QString, QString>(tr("Bhutan"), "r100307")
            << QPair<QString, QString>(tr("Bolivia"), "r100308")
            << QPair<QString, QString>(tr("Bosnia and Herzegovina"), "r100309")
            << QPair<QString, QString>(tr("Botswana"), "r100310")
            << QPair<QString, QString>(tr("Brazil"), "r101223")
            << QPair<QString, QString>(tr("Brunei Darussalam"), "r100313")
            << QPair<QString, QString>(tr("Bulgaria"), "r101225")
            << QPair<QString, QString>(tr("Burkina Faso"), "r100314")
            << QPair<QString, QString>(tr("Burundi"), "r100316")
            << QPair<QString, QString>(tr("Cambodia"), "r100317")
            << QPair<QString, QString>(tr("Cameroon"), "r101226")
            << QPair<QString, QString>(tr("Canada"), "r101227")
            << QPair<QString, QString>(tr("Cape Verde"), "r101228")
            << QPair<QString, QString>(tr("Caribbean Islands"), "r101162")
            << QPair<QString, QString>(tr("Central African Republic"), "r100320")
            << QPair<QString, QString>(tr("Chad"), "r100321")
            << QPair<QString, QString>(tr("Chile"), "r101229")
            << QPair<QString, QString>(tr("China"), "r100322")
            << QPair<QString, QString>(tr("Christmas Island"), "r100323")
            << QPair<QString, QString>(tr("Cocos Island"), "r100324")
            << QPair<QString, QString>(tr("Colombia"), "r100325")
            << QPair<QString, QString>(tr("Comoros"), "r100326")
            << QPair<QString, QString>(tr("Cook Islands"), "r100329")
            << QPair<QString, QString>(tr("Costa Rica"), "r101230")
            << QPair<QString, QString>(tr("Cote D'ivoire"), "r100330")
            << QPair<QString, QString>(tr("Croatia"), "r100331")
            << QPair<QString, QString>(tr("Cyprus"), "r101231")
            << QPair<QString, QString>(tr("Czech Republic"), "r101232")
            << QPair<QString, QString>(tr("Denmark"), "r101233")
            << QPair<QString, QString>(tr("DR Congo"), "r101627")
            << QPair<QString, QString>(tr("East Timor"), "r100334")
            << QPair<QString, QString>(tr("Ecuador"), "r100335")
            << QPair<QString, QString>(tr("Egypt"), "r101236")
            << QPair<QString, QString>(tr("El Salvador"), "r100336")
            << QPair<QString, QString>(tr("Equatorial Guinea"), "r100337")
            << QPair<QString, QString>(tr("Estonia"), "r101237")
            << QPair<QString, QString>(tr("Ethiopia"), "r100339")
            << QPair<QString, QString>(tr("Falkland Islands"), "r100340")
            << QPair<QString, QString>(tr("Faroe Islands"), "r100341")
            << QPair<QString, QString>(tr("Federated States of Micronesia"), "r100463")
            << QPair<QString, QString>(tr("Fiji"), "r101238")
            << QPair<QString, QString>(tr("Finland"), "r101239")
            << QPair<QString, QString>(tr("France"), "r101240")
            << QPair<QString, QString>(tr("French Guiana"), "r100343")
            << QPair<QString, QString>(tr("French Polynesia"), "r100344")
            << QPair<QString, QString>(tr("Gabon"), "r101241")
            << QPair<QString, QString>(tr("Gambia"), "r101242")
            << QPair<QString, QString>(tr("Georgia"), "r101435")
            << QPair<QString, QString>(tr("Germany"), "r100346")
            << QPair<QString, QString>(tr("Ghana"), "r101243")
            << QPair<QString, QString>(tr("Gibraltar"), "r100347")
            << QPair<QString, QString>(tr("Greece"), "r101244")
            << QPair<QString, QString>(tr("Greenland"), "r100348")
            << QPair<QString, QString>(tr("Guam"), "r100465")
            << QPair<QString, QString>(tr("Guatemala"), "r100350")
            << QPair<QString, QString>(tr("Guinea"), "r100351")
            << QPair<QString, QString>(tr("Guinea-Bissau"), "r101246")
            << QPair<QString, QString>(tr("Guyana"), "r101247")
            << QPair<QString, QString>(tr("Honduras"), "r100353")
            << QPair<QString, QString>(tr("Hong Kong"), "r100354")
            << QPair<QString, QString>(tr("Hungary"), "r101249")
            << QPair<QString, QString>(tr("Iceland"), "r101250")
            << QPair<QString, QString>(tr("India"), "r100355")
            << QPair<QString, QString>(tr("Indonesia"), "r100356")
            << QPair<QString, QString>(tr("Iran"), "r100357")
            << QPair<QString, QString>(tr("Iraq"), "r101251")
            << QPair<QString, QString>(tr("Ireland"), "r101252")
            << QPair<QString, QString>(tr("Israel"), "r100358")
            << QPair<QString, QString>(tr("Italy"), "r100359")
            << QPair<QString, QString>(tr("Japan"), "r101255")
            << QPair<QString, QString>(tr("Jordan"), "r100361")
            << QPair<QString, QString>(tr("Kazakhstan"), "r100362")
            << QPair<QString, QString>(tr("Kenya"), "r100363")
            << QPair<QString, QString>(tr("Kuwait"), "r101256")
            << QPair<QString, QString>(tr("Kyrgyzstan"), "r101257")
            << QPair<QString, QString>(tr("Laos"), "r100369")
            << QPair<QString, QString>(tr("Latvia"), "r101259")
            << QPair<QString, QString>(tr("Lebanon"), "r100370")
            << QPair<QString, QString>(tr("Libya"), "r101261")
            << QPair<QString, QString>(tr("Liechtenstein"), "r100373")
            << QPair<QString, QString>(tr("Lithuania"), "r100374")
            << QPair<QString, QString>(tr("Luxembourg"), "r101262")
            << QPair<QString, QString>(tr("Macau"), "r100375")
            << QPair<QString, QString>(tr("Macedonia"), "r101263")
            << QPair<QString, QString>(tr("Madagascar"), "r101264")
            << QPair<QString, QString>(tr("Malawi"), "r100376")
            << QPair<QString, QString>(tr("Malaysia"), "r101265")
            << QPair<QString, QString>(tr("Maldives"), "r101266")
            << QPair<QString, QString>(tr("Mali"), "r101267")
            << QPair<QString, QString>(tr("Malta"), "r101268")
            << QPair<QString, QString>(tr("Mauritania"), "r101269")
            << QPair<QString, QString>(tr("Mauritius"), "r101270")
            << QPair<QString, QString>(tr("Mayotte"), "r100379")
            << QPair<QString, QString>(tr("Mexico"), "r101271")
            << QPair<QString, QString>(tr("Moldova"), "r101273")
            << QPair<QString, QString>(tr("Monaco"), "r101274")
            << QPair<QString, QString>(tr("Mongolia"), "r101275")
            << QPair<QString, QString>(tr("Montenegro"), "r101358")
            << QPair<QString, QString>(tr("Morocco"), "r101276")
            << QPair<QString, QString>(tr("Mozambique"), "r101277")
            << QPair<QString, QString>(tr("Namibia"), "r100383")
            << QPair<QString, QString>(tr("Nepal"), "r101278")
            << QPair<QString, QString>(tr("Netherlands"), "r100385")
            << QPair<QString, QString>(tr("New Caledonia"), "r100387")
            << QPair<QString, QString>(tr("New Zealand"), "r101279")
            << QPair<QString, QString>(tr("Nicaragua"), "r100388")
            << QPair<QString, QString>(tr("Niger"), "r101280")
            << QPair<QString, QString>(tr("Nigeria"), "r101281")
            << QPair<QString, QString>(tr("Norfolk Island"), "r100390")
            << QPair<QString, QString>(tr("Northern Mariana Islands"), "r100481")
            << QPair<QString, QString>(tr("Norway"), "r100392")
            << QPair<QString, QString>(tr("Oman"), "r101282")
            << QPair<QString, QString>(tr("Pakistan"), "r101283")
            << QPair<QString, QString>(tr("Palau"), "r100502")
            << QPair<QString, QString>(tr("Palestine"), "r100393")
            << QPair<QString, QString>(tr("Panama"), "r101284")
            << QPair<QString, QString>(tr("Papua New Guinea"), "r100394")
            << QPair<QString, QString>(tr("Paraguay"), "r100395")
            << QPair<QString, QString>(tr("Peru"), "r101285")
            << QPair<QString, QString>(tr("Philippines"), "r100396")
            << QPair<QString, QString>(tr("Poland"), "r100398")
            << QPair<QString, QString>(tr("Portugal"), "r101286")
            << QPair<QString, QString>(tr("Qatar"), "r100399")
            << QPair<QString, QString>(tr("Reunion"), "r100400")
            << QPair<QString, QString>(tr("Romania"), "r101287")
            << QPair<QString, QString>(tr("Russia"), "r100401")
            << QPair<QString, QString>(tr("Rwanda"), "r101288")
            << QPair<QString, QString>(tr("Saudi Arabia"), "r101291")
            << QPair<QString, QString>(tr("Senegal"), "r101292")
            << QPair<QString, QString>(tr("Serbia"), "r101357")
            << QPair<QString, QString>(tr("Seychelles"), "r100408")
            << QPair<QString, QString>(tr("Sierra Leone"), "r100409")
            << QPair<QString, QString>(tr("Singapore"), "r101293")
            << QPair<QString, QString>(tr("Slovakia"), "r100410")
            << QPair<QString, QString>(tr("Slovenia"), "r100411")
            << QPair<QString, QString>(tr("Somalia"), "r101294")
            << QPair<QString, QString>(tr("South Africa"), "r101295")
            << QPair<QString, QString>(tr("South Korea"), "r100367")
            << QPair<QString, QString>(tr("Spain"), "r100416")
            << QPair<QString, QString>(tr("Sri Lanka"), "r101296")
            << QPair<QString, QString>(tr("St. Helena"), "r100417")
            << QPair<QString, QString>(tr("St. Pierre-Miquelon"), "r100419")
            << QPair<QString, QString>(tr("Sudan"), "r101298")
            << QPair<QString, QString>(tr("Suriname"), "r101299")
            << QPair<QString, QString>(tr("Sweden"), "r101300")
            << QPair<QString, QString>(tr("Switzerland"), "r100422")
            << QPair<QString, QString>(tr("Syria"), "r101301")
            << QPair<QString, QString>(tr("Taiwan"), "r101302")
            << QPair<QString, QString>(tr("Tajikistan"), "r100424")
            << QPair<QString, QString>(tr("Tanzania"), "r101303")
            << QPair<QString, QString>(tr("Thailand"), "r101304")
            << QPair<QString, QString>(tr("Togo"), "r101305")
            << QPair<QString, QString>(tr("Tunisia"), "r101307")
            << QPair<QString, QString>(tr("Turkey"), "r101308")
            << QPair<QString, QString>(tr("Uganda"), "r100433")
            << QPair<QString, QString>(tr("Ukraine"), "r100434")
            << QPair<QString, QString>(tr("United Arab Emirates"), "r100435")
            << QPair<QString, QString>(tr("United Kingdom"), "r101309")
            << QPair<QString, QString>(tr("United States"), "r100436")
            << QPair<QString, QString>(tr("Uruguay"), "r101310")
            << QPair<QString, QString>(tr("Uzbekistan"), "r101311")
            << QPair<QString, QString>(tr("Vanuatu"), "r100438")
            << QPair<QString, QString>(tr("Vatican City"), "r101312")
            << QPair<QString, QString>(tr("Venezuela"), "r101313")
            << QPair<QString, QString>(tr("Vietnam"), "r101314")
            << QPair<QString, QString>(tr("Wallis-Futuna Islands"), "r100443")
            << QPair<QString, QString>(tr("Yemen"), "r101315")
            << QPair<QString, QString>(tr("Zambia"), "r101316")
            << QPair<QString, QString>(tr("Zimbabwe"), "r101317");
}

TuneInGenreList* TuneIn::getGenres() {
    QUrl url(BASE_URL + DESCRIBE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("c", "genres");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("c", "genres");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInGenreList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInLanguageList* TuneIn::getLanguages() {
    QUrl url(BASE_URL + DESCRIBE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("c", "languages");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("c", "languages");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInLanguageList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInNameList* TuneIn::getNames(const QString &id, const QString &filter) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("pivot", "name");
    query.addQueryItem("filter", filter);
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("pivot", "name");
    url.addQueryItem("filter", filter);
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInNameList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStationList* TuneIn::searchStations(const QString &query) {
    QUrl url(BASE_URL + SEARCH_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("query", query);
    query.addQueryItem("filter", "s");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("query", query);
    url.addQueryItem("filter", "s");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInStationList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStationList* TuneIn::getStationsByCountry(const QString &id) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "s:country");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "s:country");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInStationList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStationList* TuneIn::getStationsByGenre(const QString &id) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "s");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "s");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInStationList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStationList* TuneIn::getStationsByName(const QString &id, const QString &name) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "s:~" + name);
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "s:~" + name);
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInStationList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStationList* TuneIn::getStations(const QUrl &url) {
    return new TuneInStationList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInStation* TuneIn::getStation(const QString &id) {
    QUrl url(BASE_URL + DESCRIBE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInStation(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastList* TuneIn::searchPodcasts(const QString &query) {
    QUrl url(BASE_URL + SEARCH_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("query", query);
    query.addQueryItem("filter", "p");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("query", query);
    url.addQueryItem("filter", "p");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInPodcastList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastList* TuneIn::getPodcastsByCountry(const QString &id) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "p:country");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "p:country");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInPodcastList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastList* TuneIn::getPodcastsByGenre(const QString &id) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "p");
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "p");
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInPodcastList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastList* TuneIn::getPodcastsByName(const QString &id, const QString &name) {
    QUrl url(BASE_URL + BROWSE_METHOD);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);
    query.addQueryItem("id", id);
    query.addQueryItem("filter", "p:~" + name);
    query.addQueryItem("partnerId", PARTNER_ID);
#else
    url.addQueryItem("id", id);
    url.addQueryItem("filter", "p:~" + name);
    url.addQueryItem("partnerId", PARTNER_ID);
#endif

    return new TuneInPodcastList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastList* TuneIn::getPodcasts(const QUrl &url) {
    return new TuneInPodcastList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}

TuneInPodcastEpisodeList* TuneIn::getPodcastEpisodes(const QUrl &url) {
    return new TuneInPodcastEpisodeList(NetworkAccessManager::instance()->get(QNetworkRequest(url)));
}
