/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef NETWORKPROXYDIALOG_H
#define NETWORKPROXYDIALOG_H

#include "abstractdialog.h"

class ValueSelector;
class QCheckBox;
class QLineEdit;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;

class NetworkProxyDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit NetworkProxyDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

    void loadSettings();

private slots:
    void saveSettings();
    
private:
    QCheckBox *m_proxyCheckBox;

    QWidget *m_proxyWidget;

    ValueSelector *m_proxyTypeSelector;

    QLineEdit *m_hostEdit;
    QLineEdit *m_portEdit;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;

    QScrollArea *m_scrollArea;

    QDialogButtonBox *m_buttonBox;

    QGridLayout *m_grid;
};

#endif // NETWORKPROXYDIALOG_H
