/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QMouseEvent>
#include <QPaintEvent>
#include <QPainter>
#include <QImage>
#include <QtCore/qmath.h>
#include "logolabel.h"
#include "../base/utils.h"

LogoLabel::LogoLabel(QWidget *parent) :
    QWidget(parent),
    m_interactive(true),
    m_pressed(false)
{
}

void LogoLabel::setImage(const QImage &image) {
    m_image = image;
    this->update();
}

void LogoLabel::mousePressEvent(QMouseEvent *event) {
    if (this->interactive()) {
        event->accept();
        m_pressed = true;
        this->update();
    }
    else {
        event->ignore();
    }
}

void LogoLabel::mouseReleaseEvent(QMouseEvent *event) {
    if ((this->interactive()) && (this->rect().contains(event->pos()))) {
        event->accept();
        m_pressed = false;
        this->update();
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void LogoLabel::leaveEvent(QEvent *event) {
    event->accept();
    m_pressed = false;
    this->update();
}

void LogoLabel::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (m_pressed) {
        painter.setOpacity(0.5);
    }

    if (!this->image().isNull()) {
        painter.drawImage(this->rect(), this->image());
    }

    event->accept();
}
