/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.items 1.0

MyPage {
    id: root

    function loadPodcastEpisode(episodeItem) {
        episode.loadStation(episodeItem);
    }

    title: !episode.title ? qsTr("Episode info") : episode.title
    tools: ToolBarLayout {

        BackToolButton {}

        NowPlayingButton {}
    }

    Station {
        id: episode
    }

    MyFlickable {
        id: flicker

        anchors {
            fill: parent
            margins: platformStyle.paddingLarge
        }
        contentHeight: column.height + platformStyle.paddingLarge

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }
            spacing: platformStyle.paddingLarge

            Logo {
                width: 120
                height: 120
                image: episode.logo
                text: episode.title
                enabled: (!MediaPlayer.currentStation) || (MediaPlayer.currentStation.id != episode.id)
                onClicked: appWindow.playStation(episode)
            }

            Label {
                width: parent.width
                wrapMode: Text.WordWrap
                text: episode.description
            }

            SeparatorLabel {
                width: parent.width
                text: qsTr("Properties")
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: platformStyle.fontSizeSmall
                text: qsTr("Genre") + ": " + episode.genre
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: platformStyle.fontSizeSmall
                text: qsTr("Country") + ": " + episode.country
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: platformStyle.fontSizeSmall
                text: qsTr("Language") + ": " + episode.language
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: platformStyle.fontSizeSmall
                text: qsTr("Source") + ": " + episode.source
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: platformStyle.fontSizeSmall
                text: qsTr("Last played") + ": " + Utils.dateFromMSecs(episode.lastPlayed)
                visible: episode.lastPlayed > 0
            }
        }
    }

    MyScrollBar {
        flickableItem: flicker
    }
}
