/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINWINDOW_H
#define TUNEINWINDOW_H

#include "stackedwindow.h"

class TuneInHomescreenModel;
class SearchListModel;
class ListView;
class QModelIndex;
class QGridLayout;
class QLineEdit;
class NowPlayingButton;
class ValueSelector;

class TuneInWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit TuneInWindow(QWidget *parent = 0);

private slots:
    void onItemClicked(const QModelIndex &index);

    void onSearchTypeChanged(const QVariant &type);

    void search();
    void searchStations();
    void searchPodcasts();
    void showGenres();
    void showCountries();
    void showPodcastGenres();

private:
    TuneInHomescreenModel *m_model;
    SearchListModel *m_searchModel;

    QLineEdit *m_searchEdit;

    ValueSelector *m_searchTypeSelector;

    ListView *m_view;

    QGridLayout *m_grid;

    NowPlayingButton *m_nowPlayingButton;
};

#endif // TUNEINWINDOW_H
