/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QApplication>
#include <QTranslator>
#include <QDeclarativeView>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <qdeclarative.h>
#include <QGLWidget>
#include "launcher.h"
#include "../base/homescreenmodel.h"
#include "../base/database.h"
#include "../base/stationfilterlistmodel.h"
#include "../base/podcastfilterlistmodel.h"
#include "../base/podcastepisodefilterlistmodel.h"
#include "../base/pairlistmodel.h"
#include "../base/searchlistmodel.h"
#include "../base/selectionmodels.h"
#include "../base/settings.h"
#include "../base/utils.h"
#include "../base/logodownloader.h"
#include "../base/streamextractor.h"
#include "../base/podcast.h"
#ifdef MOBILITY_PLAYER
#include "../mediaplayer/mobility/mediaplayer.h"
#else
#include "../mediaplayer/phonon/mediaplayer.h"
#endif
#include "../tunein/tuneinhomescreenmodel.h"
#include "../tunein/tuneinstationfilterlistmodel.h"
#include "../tunein/tuneinpairlistmodel.h"
#include "../tunein/tuneinpodcastfilterlistmodel.h"
#include "../tunein/tuneinpodcastepisodefilterlistmodel.h"
#include "../tunein/tuneinstation.h"

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(new QApplication(argc, argv));
    QScopedPointer<QDeclarativeView> view(new QDeclarativeView);

    app.data()->setOrganizationName("cuteRadio");
    app.data()->setApplicationName("cuteRadio");

    qRegisterMetaType< QList<Station*> >("QList<Station*>");
    qRegisterMetaType< QList<QPair<QString,int> > >("QList<QPair<QString,int> >");

    qmlRegisterType<HomescreenModel>("com.cuteradio.models", 1, 0, "HomescreenModel");
    qmlRegisterType<StationFilterListModel>("com.cuteradio.models", 1, 0, "StationListModel");
    qmlRegisterType<PodcastFilterListModel>("com.cuteradio.models", 1, 0, "PodcastListModel");
    qmlRegisterType<PodcastEpisodeFilterListModel>("com.cuteradio.models", 1, 0, "PodcastEpisodeListModel");
    qmlRegisterType<PairListModel>("com.cuteradio.models", 1, 0, "PairListModel");
    qmlRegisterType<TuneInHomescreenModel>("com.cuteradio.models", 1, 0, "TuneInHomescreenModel");
    qmlRegisterType<TuneInStationFilterListModel>("com.cuteradio.models", 1, 0, "TuneInStationListModel");
    qmlRegisterType<TuneInPairListModel>("com.cuteradio.models", 1, 0, "TuneInPairListModel");
    qmlRegisterType<TuneInPodcastFilterListModel>("com.cuteradio.models", 1, 0, "TuneInPodcastListModel");
    qmlRegisterType<TuneInPodcastEpisodeFilterListModel>("com.cuteradio.models", 1, 0, "TuneInPodcastEpisodeListModel");
    qmlRegisterType<ScreenOrientationModel>("com.cuteradio.models", 1, 0, "ScreenOrientationModel");
    qmlRegisterType<LanguageModel>("com.cuteradio.models", 1, 0, "LanguageModel");
    qmlRegisterType<MediaPlayerModel>("com.cuteradio.models", 1, 0, "MediaPlayerModel");
    qmlRegisterType<StationTypeModel>("com.cuteradio.models", 1, 0, "StationTypeModel");
    qmlRegisterType<ActiveColorModel>("com.cuteradio.models", 1, 0, "ActiveColorModel");
    qmlRegisterType<NetworkProxyTypeModel>("com.cuteradio.models", 1, 0, "NetworkProxyTypeModel");
    qmlRegisterType<Station>("com.cuteradio.items", 1, 0, "Station");
    qmlRegisterType<Podcast>("com.cuteradio.items", 1, 0, "Podcast");
    qmlRegisterType<TuneInStation>("com.cuteradio.items", 1, 0, "TuneInStation");
    qmlRegisterType<LogoDownloader>("com.cuteradio.items", 1, 0, "LogoDownloader");

    qmlRegisterUncreatableType<ScreenOrientation>("com.cuteradio.enums", 1, 0, "ScreenOrientation", "Y U create enum?");
    qmlRegisterUncreatableType<Queries>("com.cuteradio.enums", 1, 0, "Queries", "Y U create enum?");
    qmlRegisterUncreatableType<PlaybackMode>("com.cuteradio.enums", 1, 0, "PlaybackMode", "Y U create enum?");
    qmlRegisterUncreatableType<Services>("com.cuteradio.enums", 1, 0, "Services", "Y U create enum?");
    qmlRegisterUncreatableType<Stations>("com.cuteradio.enums", 1, 0, "Stations", "Y U create enum?");

    Settings settings;
    Database database;
    Utils utils;
    StreamExtractor extractor;
    MediaPlayer player;
    SearchListModel searchModel;
    Launcher launcher;

    if (!settings.language().isEmpty()) {
        QTranslator translator;
        translator.load(QString("/opt/cuteradio/translations/%1").arg(settings.language()));
        app.data()->installTranslator(&translator);
    }

    settings.setNetworkProxy();

    QDeclarativeContext *context = view.data()->rootContext();
    context->setContextProperty("Settings", &settings);
    context->setContextProperty("Utils", &utils);
    context->setContextProperty("Database", &database);
    context->setContextProperty("MediaPlayer", &player);
    context->setContextProperty("SearchModel", &searchModel);
    context->setContextProperty("StreamExtractor", &extractor);
    context->setContextProperty("Launcher", &launcher);

    view.data()->setViewport(new QGLWidget);
    view.data()->setSource(QUrl("qrc:/main.qml"));
    view.data()->showFullScreen();

    QObject::connect(&extractor, SIGNAL(gotStreamUrl(QUrl)), &launcher, SLOT(launch(QUrl)));
    QObject::connect(view.data()->engine(), SIGNAL(quit()), app.data(), SLOT(quit()));

    return app.data()->exec();
}
