/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.cuteradio.items 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MySheet {
    id: root

    function addPodcast() {
        Database.asyncAddPodcast(podcast.result.title,
                            !podcast.result.description ? qsTr("No description") : podcast.result.description,
                            !podcast.result.logo ? "" : downloader.localPath,
                            podcast.result.source);
        clear();
    }

    function clear() {
        sourceField.text = "";
    }

    Podcast {
        id: podcast

        onFinished: {
            if (result) {
                if (result.logo) {
                    downloader.url = result.logo;
                    downloader.localPath = Utils.logoPath + (result.id ? result.id :result.title) + "." + result.logo.toString().split(".").pop();
                    downloader.start();
                }
                else {
                    addPodcast();
                }
            }
            else {
                infoBanner.displayMessage(podcast.errorString);
            }
        }
    }

    LogoDownloader {
        id: downloader

        onFinished: addPodcast()
    }

    acceptButtonText: sourceField.text ? qsTr("Done") : ""
    rejectButtonText: qsTr("Cancel")
    content: Item {
        anchors.fill: parent
        clip: true

        Flickable {
            id: flicker

            anchors {
                fill: parent
                margins: UI.PADDING_DOUBLE
            }
            contentHeight: column.height + UI.PADDING_DOUBLE

            Column {
                id: column

                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }
                spacing: UI.PADDING_DOUBLE

                Label {
                    width: parent.width
                    elide: Text.ElideRight
                    font.bold: true
                    text: qsTr("Source")
                }

                MyTextField {
                    id: sourceField

                    width: parent.width
                    inputMethodHints: Qt.ImhNoAutoUppercase | Qt.ImhUrlCharactersOnly
                    onAccepted: root.accept()
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    onAccepted: podcast.load(sourceField.text)
    onRejected: clear()
}
