/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef NOWPLAYINGWINDOW_H
#define NOWPLAYINGWINDOW_H

#include "stackedwindow.h"

class Station;
class QLabel;
class ScrollArea;
class QPushButton;
class QGridLayout;

class NowPlayingWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit NowPlayingWindow(QWidget *parent = 0);

    inline bool hasNowPlayingButton() const { return false; }

private:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

    void setLandscapeLayout();
    void setPortraitLayout();

    void connectPlaybackSignals();
    void disconnectPlaybackSignals();

private slots:
    void onPlayButtonClicked();

    void onCurrentStationChanged(Station *station);
    void onMetaDataChanged();

    void onPlaybackStateChanged();
    void onPlaybackPositionChanged(qint64 position);

    void onSleepTimerEnabledChanged(bool enabled);
    void onSleepTimerRemainingChanged(qint64 remaining);

    void onScreenLockStateChanged(bool locked);

private:
    QLabel *m_descriptionLabel;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_albumLabel;
    QLabel *m_genreLabel;
    QLabel *m_bitrateLabel;
    QLabel *m_positionLabel;
    QLabel *m_statusLabel;

    ScrollArea *m_scrollArea;

    QWidget *m_controls;

    QPushButton *m_playButton;
    QPushButton *m_sleepTimerButton;

    QGridLayout *m_grid;
};

#endif // NOWPLAYINGWINDOW_H
