/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"

class QDialogButtonBox;
class QScrollArea;
class QGridLayout;
class ValueSelector;
class QSpinBox;
class NetworkProxyDialog;

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void loadSettings();
    void saveSettings();

    void showNetworkProxyDialog();
    
private:
    ValueSelector *m_orientationSelector;
    ValueSelector *m_languageSelector;

    QPushButton *m_proxyButton;

    QSpinBox *m_sleepTimerSpinBox;

    QDialogButtonBox *m_buttonBox;

    QScrollArea *m_scrollArea;

    QGridLayout *m_grid;

    NetworkProxyDialog *m_proxyDialog;
};

#endif // SETTINGSDIALOG_H
