#include <QNetworkReply>
#include <QAuthenticator>
#include "networkaccessmanager.h"
#include "settings.h"

NetworkAccessManager::NetworkAccessManager(QObject *parent) :
    QNetworkAccessManager(parent)
{
    this->connect(this, SIGNAL(sslErrors(QNetworkReply*,QList<QSslError>)), this, SLOT(onSSLErrors(QNetworkReply*,QList<QSslError>)));
    this->connect(this, SIGNAL(proxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)), this, SLOT(onProxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)));
}

void NetworkAccessManager::onSSLErrors(QNetworkReply *reply, const QList<QSslError> &errors) {
    reply->ignoreSslErrors(errors);
}

void NetworkAccessManager::onProxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator) {
    Q_UNUSED(proxy)

    authenticator->setUser(Settings::instance()->networkProxyUser());
    authenticator->setPassword(Settings::instance()->networkProxyPassword());
}
