TEMPLATE = app
TARGET = cuteradio
QT += network sql xml phonon

HEADERS += $$files(src/base/*.h) \
    src/mediaplayer/phonon/mediaplayer.h
SOURCES += $$files(src/base/*.cpp) \
    src/mediaplayer/phonon/mediaplayer.cpp

INSTALLS += target

maemo5 {
    system(lupdate src/base/*.* src/mediaplayer/phonon/*.* src/maemo5/*.* -ts translations/maemo5/base.ts)
    system(cp translations/maemo5/base.ts translations/maemo5/en.ts)
    system(lrelease translations/maemo5/en.ts)

    QT += maemo5 dbus
    HEADERS += $$files(src/maemo5/*.h)
    SOURCES += $$files(src/maemo5/*.cpp)

    target.path = /opt/cuteradio/bin

    stations.files = stations/cuteradio.db
    stations.path = /opt/cuteradio/stations

    desktop.files = desktop/maemo5/cuteradio.desktop
    desktop.path = /usr/share/applications/hildon

    icon.files = desktop/maemo5/64x64/cuteradio.png
    icon.path = /usr/share/icons/hicolor/64x64/apps

    translations.files = $$files(translations/maemo5/*.qm)
    translations.path = /opt/cuteradio/translations

    INSTALLS += desktop icon stations translations
}

symbian {
    system(lupdate src/base/*.* src/mediaplayer/phonon/*.* src/symbian/*.* qml/symbian/*.qml -ts translations/symbian/base.ts)
    system(cp translations/symbian/base.ts translations/symbian/en.ts)
    system(lrelease translations/symbian/en.ts)

    TARGET = cuteradio_0xe71cbb8d
    DEFINES += QML_USER_INTERFACE
    CONFIG += qtcomponents
    TARGET.UID3 = 0xE71CBB8D
    TARGET.CAPABILITY += NetworkServices ReadUserData
    INCLUDEPATH += MW_LAYER_SYSTEMINCLUDE
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconcoreapi
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconinterfacebase
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    HEADERS += $$files(src/symbian/*.h) \
        $$files(src/qml/*.h) \
        $$files(src/symbian/volumekeys/*.h)
    SOURCES += $$files(src/symbian/*.cpp) \
        $$files(src/qml/*.cpp) \
        $$files(src/symbian/volumekeys/*.cpp)
    RESOURCES += qml/symbian/resources.qrc
    OTHER_FILES += $$files(qml/symbian/*.qml)

    DEPLOYMENT.display_name = cuteRadio
    VERSION = 0.1.0
    ICON = desktop/symbian/cuteradio.svg

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""
    my_deployment.pkg_prerules += vendorinfo

    stations.sources = stations/cuteradio.db
    stations.path = C:\Private\e71cbb8d\stations

    translations.files = $$files(translations/symbian/*.qm)
    translations.path = C:\Private\e71cbb8d\translations

    DEPLOYMENT += my_deployment stations translations
}

simulator {
    DEFINES += QML_USER_INTERFACE
    CONFIG += qtcomponents
    HEADERS += $$files(src/symbian/*.h)
    SOURCES += $$files(src/symbian/*.cpp)
    RESOURCES += qml/symbian/resources.qrc
    OTHER_FILES += $$files(qml/symbian/*.qml)
}

contains(MEEGO_EDITION,harmattan) {
    system(lupdate src/base/*.* src/mediaplayer/phonon/*.* src/harmattan/*.* qml/harmattan/*.qml -ts translations/harmattan/base.ts)
    system(cp translations/harmattan/base.ts translations/harmattan/en.ts)
    system(lrelease translations/harmattan/en.ts)

    DEFINES += QML_USER_INTERFACE
    QT += opengl
    CONFIG += qdeclarative-boostable
    INCLUDEPATH += /usr/include/resource/qt4
    LIBS += -lresourceqt
    HEADERS += $$files(src/harmattan/*.h)
    SOURCES += $$files(src/harmattan/*.cpp)
    RESOURCES += qml/harmattan/resources.qrc
    OTHER_FILES += \
        qtc_packaging/debian_harmattan/rules \
        qtc_packaging/debian_harmattan/README \
        qtc_packaging/debian_harmattan/manifest.aegis \
        qtc_packaging/debian_harmattan/copyright \
        qtc_packaging/debian_harmattan/control \
        qtc_packaging/debian_harmattan/compat \
        qtc_packaging/debian_harmattan/changelog \
        qtc_packaging/debian_harmattan/postinst

    OTHER_FILES += $$files(qml/harmattan/*.qml)

    target.path = /opt/cuteradio/bin

    stations.files = stations/cuteradio.db
    stations.path = /opt/cuteradio/stations

    policy.files = policy/cuteradio.conf
    policy.path = /usr/share/policy/etc/syspart.conf.d

    desktop.files = desktop/harmattan/cuteradio.desktop
    desktop.path = /usr/share/applications

    icon.files = desktop/harmattan/80x80/cuteradio.png
    icon.path = /usr/share/icons/hicolor/80x80/apps

    splash.files = $$files(desktop/harmattan/splash/*.png)
    splash.path = /opt/cuteradio/splash

    translations.files = $$files(translations/harmattan/*.qm)
    translations.path = /opt/cuteradio/translations

    INSTALLS += desktop icon splash stations policy translations
}

contains(DEFINES,QML_USER_INTERFACE) {
    QT += declarative
}
