#ifndef BROWSELISTWINDOW_H
#define BROWSELISTWINDOW_H

#include "stackedwindow.h"

class PairListModel;
class ListView;
class FilterBox;
class QLabel;
class QModelIndex;
class QVBoxLayout;

class BrowseListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit BrowseListWindow(QWidget *parent = 0);

public slots:
    void showGenres();
    void showCountries();
    void showLanguages();

    void clear();
    void reload();

private:
    void showEvent(QShowEvent *event);
    void keyPressEvent(QKeyEvent *event);

private slots:
    void onScrollingStopped();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

private:
    ListView *m_view;
    PairListModel *m_model;

    FilterBox *m_filterBox;

    QLabel *m_noResultsLabel;

    QVBoxLayout *m_vbox;
};

#endif // BROWSELISTWINDOW_H
