/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef ADDSTATIONDIALOG_H
#define ADDSTATIONDIALOG_H

#include "abstractdialog.h"

class QLineEdit;
class QTextEdit;
class QCheckBox;
class QDialogButtonBox;
class QGridLayout;
class ScrollArea;
class Station;

class AddStationDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit AddStationDialog(QWidget *parent = 0);
    explicit AddStationDialog(Station *station, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    
private slots:
    void onTitleChanged(const QString &title);
    void onSourceChanged(const QString &source);

    void addStation();
    void editStation();

private:
    Station *m_station;

    QLineEdit *m_titleEdit;
    QLineEdit *m_genreEdit;
    QLineEdit *m_countryEdit;
    QLineEdit *m_languageEdit;
    QLineEdit *m_sourceEdit;

    QTextEdit *m_descriptionEdit;

    QCheckBox *m_favouriteCheckBox;

    ScrollArea *m_scrollArea;

    QDialogButtonBox *m_buttonBox;

    QGridLayout *m_grid;
};

#endif // ADDSTATIONDIALOG_H
