/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QApplication>
#include <QDeclarativeView>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <qdeclarative.h>
#include <QGLWidget>
#include "../base/homescreenmodel.h"
#include "../base/database.h"
#include "../base/stationfilterlistmodel.h"
#include "../base/pairlistmodel.h"
#include "../base/searchlistmodel.h"
#include "../base/selectionmodels.h"
#include "../base/settings.h"
#include "../base/utils.h"
#include "../mediaplayer/phonon/mediaplayer.h"

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(new QApplication(argc, argv));
    QScopedPointer<QDeclarativeView> view(new QDeclarativeView);

    app.data()->setOrganizationName("cuteRadio");
    app.data()->setApplicationName("cuteRadio");

    qRegisterMetaType< QList<Station*> >("QList<Station*>");
    qRegisterMetaType< QList<QPair<QString,int> > >("QList<QPair<QString,int> >");

    qmlRegisterType<HomescreenModel>("com.cuteradio.models", 1, 0, "HomescreenModel");
    qmlRegisterType<StationFilterListModel>("com.cuteradio.models", 1, 0, "StationListModel");
    qmlRegisterType<PairListModel>("com.cuteradio.models", 1, 0, "PairListModel");
    qmlRegisterType<ScreenOrientationModel>("com.cuteradio.models", 1, 0, "ScreenOrientationModel");
    qmlRegisterType<ActiveColorModel>("com.cuteradio.models", 1, 0, "ActiveColorModel");
    qmlRegisterType<Station>("com.cuteradio.items", 1, 0, "Station");

    qmlRegisterUncreatableType<ScreenOrientation>("com.cuteradio.enums", 1, 0, "ScreenOrientation", "Y U create enum?");
    qmlRegisterUncreatableType<Queries>("com.cuteradio.enums", 1, 0, "Queries", "Y U create enum?");
    qmlRegisterUncreatableType<PlaybackMode>("com.cuteradio.enums", 1, 0, "PlaybackMode", "Y U create enum?");

    Settings settings;
    Database database;
    Utils utils;
    MediaPlayer player;
    SearchListModel searchModel;

    QDeclarativeContext *context = view.data()->rootContext();
    context->setContextProperty("Settings", &settings);
    context->setContextProperty("Utils", &utils);
    context->setContextProperty("Database", &database);
    context->setContextProperty("MediaPlayer", &player);
    context->setContextProperty("SearchModel", &searchModel);

    view.data()->setViewport(new QGLWidget);
    view.data()->setSource(QUrl("qrc:/main.qml"));
    view.data()->showFullScreen();

    QObject::connect(view.data()->engine(), SIGNAL(quit()), app.data(), SLOT(quit()));

    return app.data()->exec();
}
