/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

ListItem {
    id: root

    property alias title: title.text
    property variant initialValue
    property variant currentValue
    property alias model: selectionDialog.model

    signal valueChosen(variant value)

    function setInitialValue(value) {
        var found = false;
        var i = 0;
        while ((!found) && (i < model.count)) {
            if (model.get(i).value === value) {
                selectionDialog.selectedIndex = i;
                found = true;
            }
            i++;
        }

        currentValue = value;
    }

    width: parent.width
    height: 84
    opacity: enabled ? UI.OPACITY_ENABLED : UI.OPACITY_DISABLED
    onClicked: selectionDialog.open()

    Component.onCompleted: if (initialValue !== undefined) setInitialValue(initialValue);

    Column {

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: icon.left
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        Label {
            id: title

            width: parent.width
            elide: Text.ElideRight
            font.bold: true
            verticalAlignment: Text.AlignVCenter
        }

        Label {
            id: subTitle

            width: parent.width
            elide: Text.ElideRight
            color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
            verticalAlignment: Text.AlignVCenter
            text: selectionDialog.selectedIndex < 0 ? "" : model.get(selectionDialog.selectedIndex).name
        }
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        source: theme.inverted ? "image://theme/icon-m-textinput-combobox-arrow" : "image://theme/icon-m-common-combobox-arrow"
    }

    SelectionDialog {
        id: selectionDialog

        selectedIndex: -1
        titleText: title.text
        delegate: Item {
            id: delegateItem
            property bool selected: index === selectedIndex;

            height: selectionDialog.platformStyle.itemHeight
            anchors.left: parent.left
            anchors.right: parent.right
            visible: value !== ""

            MouseArea {
                id: delegateMouseArea
                anchors.fill: parent;
                onPressed: selectedIndex = index;
                onClicked:  accept();
            }


            Rectangle {
                id: backgroundRect
                anchors.fill: parent
                color: delegateItem.selected ? selectionDialog.platformStyle.itemSelectedBackgroundColor : selectionDialog.platformStyle.itemBackgroundColor
            }

            BorderImage {
                id: background
                anchors.fill: parent
                border {
                    left: 22
                    top: 22
                    right: 22
                    bottom: 22
                }
                source: delegateMouseArea.pressed ? selectionDialog.platformStyle.itemPressedBackground :
                        delegateItem.selected ? selectionDialog.platformStyle.itemSelectedBackground :
                        selectionDialog.platformStyle.itemBackground
            }

            Text {
                id: itemText

                elide: Text.ElideRight
                color: delegateItem.selected ? selectionDialog.platformStyle.itemSelectedTextColor : selectionDialog.platformStyle.itemTextColor
                anchors.verticalCenter: delegateItem.verticalCenter
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.leftMargin: selectionDialog.platformStyle.itemLeftMargin
                anchors.rightMargin: selectionDialog.platformStyle.itemRightMargin
                text: name
                font: selectionDialog.platformStyle.itemFont
            }
        }
        onAccepted: valueChosen(model.get(selectedIndex).value)
    }
}
