/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    height: 72

    property alias searchText: textField.text
    property alias placeholderText: textField.placeholderText
    property alias actionLabel: textField.actionLabel
    property string __invertedString: theme.inverted ? "-inverted" : ""
    property string __screenOrientation: appWindow.inPortrait ? "portrait" : "landscape"

    signal accepted

    function platformCloseSoftwareInputPanel() {
        textField.platformCloseSoftwareInputPanel();
    }

    Image {
        anchors.fill: parent
        source: "image://theme/meegotouch-tab-" + __screenOrientation + "-bottom" + __invertedString + "-background"
        fillMode: Image.Stretch
    }

    MyTextField {
        id: textField

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        rightMargin: 55
        actionLabel: qsTr("Search")
        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
        onTextChanged: if (!text) platformCloseSoftwareInputPanel();
        onAccepted: {
            platformCloseSoftwareInputPanel();
            root.accepted();
        }
    }

    Image {
        id: icon

        z: 1000
        anchors {
            right: textField.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: textField.verticalCenter
        }
        source: "image://theme/icon-m-input-clear"
        opacity: mouseArea.pressed ? 0.5 : 1
        visible: textField.text != ""

        MouseArea {
            id: mouseArea

            width: 60
            height: 60
            anchors.centerIn: parent
            onClicked: {
                textField.text = "";
                textField.platformCloseSoftwareInputPanel();
            }
        }
    }

    Rectangle {
        height: 1
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        opacity: 0.5
    }

    onAccepted: {
        focus = false;
        textField.platformCloseSoftwareInputPanel();
    }
}
